/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class BTClient
implements Runnable,
DiscoveryListener {
    final UUID SERVER_UUID = new UUID("F0E0D0C0B0A000908070605040302010", false);
    final int ATTRIBUTE_ID;
    final int READY;
    final int DEVICE_SEARCH;
    final int SERVICE_SEARCH;
    int state = 0;
    int discType;
    DiscoveryAgent discoveryAgent;
    boolean isClosed;
    Thread thread;
    RecordStore store;
    RecordEnumeration re;
    Vector devices = new Vector();
    Vector records = new Vector();
    cardMID cardMidlet;
    private int[] searchIDs;
    UUID[] uuidSet;
    int[] attrSet;

    public BTClient(cardMID cardMID2) {
        this.ATTRIBUTE_ID = 17185;
        this.READY = 0;
        this.DEVICE_SEARCH = 1;
        this.SERVICE_SEARCH = 2;
        this.cardMidlet = cardMID2;
        try {
            this.store = RecordStore.openRecordStore((String)"Friend", (boolean)true);
            this.re = this.store.enumerateRecords(null, null, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        boolean bl = false;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("can't initialize");
        }
        if (!bl) {
            return;
        }
        this.uuidSet = new UUID[2];
        this.uuidSet[0] = new UUID(4353L);
        this.uuidSet[1] = this.SERVER_UUID;
        this.attrSet = new int[1];
        this.attrSet[0] = 17185;
        this.search();
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        System.out.println("deviceDiscovered!!!");
        if (this.devices.indexOf(remoteDevice) == -1) {
            this.devices.addElement(remoteDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int n) {
        System.out.println("inquiryCompleted!!!");
        System.out.println(this.devices.size() + " devices were found~");
        this.discType = n;
        BTClient bTClient = this;
        synchronized (bTClient) {
            this.notify();
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        System.out.println("servicesDiscovered!!!");
        for (int i = 0; i < serviceRecordArray.length; ++i) {
            this.records.addElement(serviceRecordArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int n, int n2) {
        int n3;
        System.out.println("serviceSearchCompleted!!!");
        int n4 = -1;
        for (n3 = 0; n3 < this.searchIDs.length; ++n3) {
            if (this.searchIDs[n3] != n) continue;
            n4 = n3;
            break;
        }
        if (n4 == -1) {
            System.err.println("Unexpected transaction index: " + n);
        } else {
            this.searchIDs[n4] = -1;
        }
        for (n3 = 0; n3 < this.searchIDs.length; ++n3) {
            if (this.searchIDs[n3] == -1) continue;
            return;
        }
        BTClient bTClient = this;
        synchronized (bTClient) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        BTClient bTClient = this;
        synchronized (bTClient) {
            this.isClosed = true;
            this.notify();
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void search() {
        while (!this.isClosed) {
            this.state = 0;
            if (this.isClosed) {
                return;
            }
            if (!this.searchDevices()) {
                return;
            }
            if (this.devices.size() == 0) continue;
            if (!this.searchServices()) {
                return;
            }
            if (this.records.size() == 0 || !this.show()) continue;
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Unexpected interuption: " + interruptedException);
                    return;
                }
            } while (!this.isClosed);
            return;
        }
    }

    public boolean searchDevices() {
        this.state = 1;
        this.devices.removeAllElements();
        try {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException bluetoothStateException) {
            System.err.println("Can't start inquiry now: " + (Object)((Object)bluetoothStateException));
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Unexpected interuption: " + interruptedException);
            return false;
        }
        if (this.isClosed) {
            return false;
        }
        switch (this.discType) {
            case 7: {
                System.err.println("Device discovering error...");
                break;
            }
            case 5: {
                this.devices.removeAllElements();
                break;
            }
            case 0: {
                if (this.devices.size() != 0) break;
                System.err.println("No devices in range");
                break;
            }
            default: {
                System.err.println("system error: unexpected device discovery code: " + this.discType);
                this.destroy();
                return false;
            }
        }
        return true;
    }

    public boolean searchServices() {
        this.state = 2;
        this.records.removeAllElements();
        this.searchIDs = new int[this.devices.size()];
        boolean bl = false;
        for (int i = 0; i < this.devices.size(); ++i) {
            RemoteDevice remoteDevice = (RemoteDevice)this.devices.elementAt(i);
            try {
                this.searchIDs[i] = this.discoveryAgent.searchServices(this.attrSet, this.uuidSet, remoteDevice, (DiscoveryListener)this);
            }
            catch (Exception exception) {
                System.err.println("Can't search services for: " + remoteDevice.getBluetoothAddress() + " due to " + exception);
                this.searchIDs[i] = -1;
                continue;
            }
            bl = true;
        }
        if (!bl) {
            System.err.println("Can't search services.");
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Unexpected interuption: " + interruptedException);
            return false;
        }
        if (this.isClosed) {
            return false;
        }
        if (this.records.size() == 0) {
            System.err.println("No proper services were found");
        }
        return true;
    }

    public boolean show() {
        for (int i = 0; i < this.records.size(); ++i) {
            ServiceRecord serviceRecord = (ServiceRecord)this.records.elementAt(i);
            DataElement dataElement = serviceRecord.getAttributeValue(17185);
            if (dataElement == null) {
                System.err.println("Unexpected service - missed attribute");
                continue;
            }
            String string = (String)dataElement.getValue();
            System.out.println(string);
            CardToString cardToString = new CardToString(string);
            Friend friend = cardToString.friend;
            System.out.println(friend.name);
            try {
                boolean bl = true;
                friend.write(this.store, bl, this.cardMidlet.lastView);
                this.cardMidlet.lastView = this.store.getNumRecords();
                this.cardMidlet.show(this.store.getNumRecords());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }
}

